/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GDimension;
import acm.graphics.GPoint;
import java.awt.Rectangle;

public class GRectangle {
    private double xc;
    private double yc;
    private double myWidth;
    private double myHeight;

    public GRectangle() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public GRectangle(double d, double d2, double d3, double d4) {
        this.xc = d;
        this.yc = d2;
        this.myWidth = d3;
        this.myHeight = d4;
    }

    public GRectangle(double d, double d2) {
        this(0.0, 0.0, d, d2);
    }

    public GRectangle(GPoint gPoint, GDimension gDimension) {
        this(gPoint.getX(), gPoint.getY(), gDimension.getWidth(), gDimension.getHeight());
    }

    public GRectangle(GPoint gPoint) {
        this(gPoint.getX(), gPoint.getY(), 0.0, 0.0);
    }

    public GRectangle(GDimension gDimension) {
        this(0.0, 0.0, gDimension.getWidth(), gDimension.getHeight());
    }

    public GRectangle(GRectangle gRectangle) {
        this(gRectangle.xc, gRectangle.yc, gRectangle.myWidth, gRectangle.myHeight);
    }

    public double getX() {
        return this.xc;
    }

    public double getY() {
        return this.yc;
    }

    public double getWidth() {
        return this.myWidth;
    }

    public double getHeight() {
        return this.myHeight;
    }

    public void setBounds(double d, double d2, double d3, double d4) {
        this.xc = d;
        this.yc = d2;
        this.myWidth = d3;
        this.myHeight = d4;
    }

    public void setBounds(GPoint gPoint, GDimension gDimension) {
        this.setBounds(gPoint.getX(), gPoint.getY(), gDimension.getWidth(), gDimension.getHeight());
    }

    public void setBounds(GRectangle gRectangle) {
        this.setBounds(gRectangle.xc, gRectangle.yc, gRectangle.myWidth, gRectangle.myHeight);
    }

    public GRectangle getBounds() {
        return new GRectangle(this);
    }

    public void setLocation(double d, double d2) {
        this.xc = d;
        this.yc = d2;
    }

    public void setLocation(GPoint gPoint) {
        this.setLocation(gPoint.getX(), gPoint.getY());
    }

    public GPoint getLocation() {
        return new GPoint(this.xc, this.yc);
    }

    public void translate(double d, double d2) {
        this.xc += d;
        this.yc += d2;
    }

    public void setSize(double d, double d2) {
        this.myWidth = d;
        this.myHeight = d2;
    }

    public void setSize(GDimension gDimension) {
        this.setSize(gDimension.getWidth(), gDimension.getHeight());
    }

    public GDimension getSize() {
        return new GDimension(this.myWidth, this.myHeight);
    }

    public void grow(double d, double d2) {
        this.xc -= d;
        this.yc -= d2;
        this.myWidth += 2.0 * d;
        this.myHeight += 2.0 * d2;
    }

    public boolean isEmpty() {
        return this.myWidth <= 0.0 || this.myHeight <= 0.0;
    }

    public boolean contains(double d, double d2) {
        return d >= this.xc && d2 >= this.yc && d < this.xc + this.myWidth && d2 < this.yc + this.myHeight;
    }

    public boolean contains(GPoint gPoint) {
        return this.contains(gPoint.getX(), gPoint.getY());
    }

    public boolean intersects(GRectangle gRectangle) {
        if (this.xc > gRectangle.xc + gRectangle.myWidth) {
            return false;
        }
        if (this.yc > gRectangle.yc + gRectangle.myHeight) {
            return false;
        }
        if (gRectangle.xc > this.xc + this.myWidth) {
            return false;
        }
        return !(gRectangle.yc > this.yc + this.myHeight);
    }

    public GRectangle intersection(GRectangle gRectangle) {
        double d = Math.max(this.xc, gRectangle.xc);
        double d2 = Math.max(this.yc, gRectangle.yc);
        double d3 = Math.min(this.xc + this.myWidth, gRectangle.xc + gRectangle.myWidth);
        double d4 = Math.min(this.yc + this.myHeight, gRectangle.yc + gRectangle.myHeight);
        return new GRectangle(d, d2, d3 - d, d4 - d2);
    }

    public GRectangle union(GRectangle gRectangle) {
        if (this.isEmpty()) {
            return new GRectangle(gRectangle);
        }
        if (gRectangle.isEmpty()) {
            return new GRectangle(this);
        }
        double d = Math.min(this.xc, gRectangle.xc);
        double d2 = Math.min(this.yc, gRectangle.yc);
        double d3 = Math.max(this.xc + this.myWidth, gRectangle.xc + gRectangle.myWidth);
        double d4 = Math.max(this.yc + this.myHeight, gRectangle.yc + gRectangle.myHeight);
        return new GRectangle(d, d2, d3 - d, d4 - d2);
    }

    public void add(GRectangle gRectangle) {
        if (gRectangle.isEmpty()) {
            return;
        }
        if (this.isEmpty()) {
            this.setBounds(gRectangle);
            return;
        }
        double d = Math.max(this.xc + this.myWidth, gRectangle.xc + gRectangle.myWidth);
        double d2 = Math.max(this.yc + this.myHeight, gRectangle.yc + gRectangle.myHeight);
        this.xc = Math.min(gRectangle.xc, this.xc);
        this.yc = Math.min(gRectangle.yc, this.yc);
        this.myWidth = d - this.xc;
        this.myHeight = d2 - this.yc;
    }

    public void add(double d, double d2) {
        if (this.isEmpty()) {
            this.setBounds(d, d2, 0.0, 0.0);
            return;
        }
        double d3 = Math.max(d + this.myWidth, d);
        double d4 = Math.max(d2 + this.myHeight, d2);
        this.xc = Math.min(d, this.xc);
        this.yc = Math.min(d2, this.yc);
        this.myWidth = d3 - this.xc;
        this.myHeight = d4 - this.yc;
    }

    public Rectangle toRectangle() {
        return new Rectangle((int)Math.round(this.xc), (int)Math.round(this.yc), (int)Math.round(this.myWidth), (int)Math.round(this.myHeight));
    }

    public int hashCode() {
        return new Float((float)this.xc).hashCode() ^ new Float((float)this.yc).hashCode() ^ new Float((float)this.myWidth).hashCode() ^ new Float((float)this.myHeight).hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof GRectangle)) {
            return false;
        }
        GRectangle gRectangle = (GRectangle)object;
        if ((float)this.xc != (float)gRectangle.xc) {
            return false;
        }
        if ((float)this.yc != (float)gRectangle.yc) {
            return false;
        }
        if ((float)this.myWidth != (float)gRectangle.myWidth) {
            return false;
        }
        return (float)this.myHeight == (float)gRectangle.myHeight;
    }

    public String toString() {
        return "[" + (float)this.xc + ", " + (float)this.yc + ", " + (float)this.myWidth + "x" + (float)this.myHeight + "]";
    }
}

